
#define ProductName "w2d/s2d"
#define FixName "Hotfix"
#define Publisher "Volker Warmers"
#define HomeUrl "www.warmers.de"
#define SupportUrl "forum.w2d-siquando.de"
#define OutputFileName "ws2d_fix"
;#define ExeFile "web2date.exe"
#define MajorVersion "2"
#define MinorVersion "0"
#define BuildVersion "4"
#define ServicePackVersion "0"
#define AppVersion MajorVersion + "." + MinorVersion + "." + BuildVersion + "." + ServicePackVersion
#define AppMutex "web2date"

#define CurrentYear GetDateTimeString('yyyy','','')

#define StylesFile "Vista.cjstyles"
#define StylesIniFile ""
;#define StylesIniFile "NormalAqua.ini"
;#define StylesIniFile "NormalBlack.ini"
;#define StylesIniFile "NormalBlack2.ini"
;#define StylesIniFile "NormalBlue.ini"
;#define StylesIniFile "NormalSilver.ini"

#define fixruntimeerror
#define killupdatechecker
#define deletetempfolder

#define cpdriver

#define vbruntime6
#define mdac28
#define jet40

#define DonateUrl "https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=XGA7FDL6832ZC"

;#define debugmode

[Messages]
BeveledLabel=    Copyright  {#CurrentYear} by V. Warmers  Steinsstrae 35  41238 Mnchengladbach  {#HomeUrl}   

[CustomMessages]
;LicenseFile=Lizenz.txt
de.InstallMsg1=Komponenten-Installation
de.InstallMsg2=Installiere:

en.InstallMsg1=Component Installation
en.InstallMsg2=Installing:

es.InstallMsg1=Componentes-Instalacion
es.InstallMsg2=Instalar:

fr.InstallMsg1=Installation des composants
fr.InstallMsg2=En cours dinstallation:

nl.InstallMsg1=Component installatie
nl.InstallMsg2=Installeren:

tr.InstallMsg1=Bileen-Yklemesi
tr.InstallMsg2=Ykleniyor:

InstallVB6Rt=Visual Basic 6 Runtime SP6 ...
InstallMDAC2_8=MDAC 2.8 ...
InstallJET4_0=JET 4.0 ...

de.InstallCpDrivers=Kopierschutz-Treiber ...
en.InstallCpDrivers=Copy Protection Drivers ...
es.InstallCpDrivers=Drivers Copy Protection ...
fr.InstallCpDrivers=Pilotes de protection anti-copie ...
nl.InstallCpDrivers=Copy Protection Drivers ...
tr.InstallCpDrivers=Kopya Koruma Srcler ...

DBstartFile=DBstart.exe
;DBstartTxt=DATA BECKER Info-Browser
;UpdateControlTxt=DATA BECKER Update Service
SharedDirName=DATA BECKER Shared
UpdateExe=DATA BECKER Update Service.exe
ServiceExe=DBService.exe
UninstExe=DBuninst.exe

AllGroupDescription=

; BillBoard-Optionen
; Anzahl der anzuzeigenden Bilder
;BillBoardCount=1
; Anzeige-Verzgerung in Sekunden
;BillBoardDelay=0

; Lizenztext drucken
de.TxtLicensePrintOnDefaultPrinter=Mchten Sie die Lizenzdatei ber den Standard-Drucker ausdrucken?
de.TxtLicensePrintFailed=Beim Drucken der Lizenzdatei ist ein Problem aufgetreten!
de.TxtLicenseExtractFailed=Beim Extrahieren der Lizenzdatei ist ein Problem aufgetreten!
de.TxtLicensePrintButton=Lizenz &drucken

en.TxtLicensePrintOnDefaultPrinter=Would you like to print the license agreement on the standard printer?
en.TxtLicensePrintFailed=A problem occured while printing the license agreement!
en.TxtLicenseExtractFailed=A problem occured while extracting the license agreement!
en.TxtLicensePrintButton=&Print license

es.TxtLicensePrintOnDefaultPrinter=Le gustara imprimir la licencia con la impresora predeterminada?
es.TxtLicensePrintFailed=Se produjo un problema al imprimir el archivo de licencia!
es.TxtLicenseExtractFailed=Se produjo un problema al extraer el archivo de licencia!
es.TxtLicensePrintButton=Imprimir &licencia

fr.TxtLicensePrintOnDefaultPrinter=Souhaitez-vous imprimer la licence sur limprimante standard?
fr.TxtLicensePrintFailed=Un problme est survenu lors de limpression des donnes de la licence!
fr.TxtLicenseExtractFailed=Un problme est survenu lors de lextraction des donnes de la licence!
fr.TxtLicensePrintButton=&Imprimer la licence

nl.TxtLicensePrintOnDefaultPrinter=Wilt u de licentie op de standaard printer afdrukken?
nl.TxtLicensePrintFailed=Tijdens het afdrukken van de licentie heeft zich een probleem voorgedaan!
nl.TxtLicenseExtractFailed=Er is een probleem opgetreden tijdens het uitpakken van de licentie!
nl.TxtLicensePrintButton=Licentie &afdrukken

tr.TxtLicensePrintOnDefaultPrinter=Bu Lisans standart yazcnzla basmak istermisiniz?
tr.TxtLicensePrintFailed=Lisans dosyasn basarken bir sorun kt!
tr.TxtLicenseExtractFailed=Lisans dosyasn ayklarken bir sorun kt!
tr.TxtLicensePrintButton=Lisans &yazdr

; Project Messages
de.AppNotFoundMsg=web/shop to date 6, 7, 8 oder 8s konnte auf Ihrem System nicht gefunden werden.%n%nDie Installation des {#ProductName} {#FixName}es wird jetzt abgebrochen.
de.AppIsInUseMsg=web/shop to date wird noch ausgefhrt.%n%nUm den {#ProductName} {#FixName} zu installieren, schlieen Sie bitte das Programm und klicken Sie anschlieend auf OK.
;de.DeleteTempFolderGroupDescription=%nEs wird empfohlen, die Temp-Verzeichnisse auf Ihrem System zu subern. Soll das Hotfix-Setup dies jetzt fr Sie vornehmen?%n

de.FixRuntimeErrorDescription=Laufzeitfehler '-2147220502 (800403ea)': </head> invalid here beheben
de.KillUpdateCheckerDescription=DATA BECKER UpdateChecker vollstndig vom System entfernen
de.DeleteTempFolderDescription=Temporre Verzeichnisse auf dem System subern
de.InstallVb6Description=Microsoft Visual Basic 6 Runtime SP6 Komponenten reparieren
de.InstallMdacDescription=Microsoft Data Access Komponenten (MDAC) reparieren
de.InstallJetDescription=Microsoft JET Komponenten reparieren
de.InstallProtectDriversDescription=DATA BECKER Kopierschutz-Treiber reparieren
de.DonateTxt=Ich mchte dem {#SupportUrl} etwas spenden

en.AppNotFoundMsg=web/shop to date 6, 7, 8 or 8s couldn't be found on your system.%n%nThe installation of {#ProductName} {#FixName} will now be cancelled.
en.AppIsInUseMsg=web/shop to date is currently running.%n%nTo install {#ProductName} {#FixName} please close the program and then click OK.
;en.DeleteTempFolderGroupDescription=%nIt's recommended to clean the temp directories on your system. Do you want the hotfix setup to do that for you now?%n

en.FixRuntimeErrorDescription=Fix runtime error '-2147220502 (800403ea)': </head> invalid here
en.KillUpdateCheckerDescription=Completely remove DATA BECKER UpdateChecker from the system
en.DeleteTempFolderDescription=Clean temporary directories on the system
en.InstallVb6Description=Repair Microsoft Visual Basic 6 Runtime SP6 components
en.InstallMdacDescription=Repair Microsoft Data Access components (MDAC)
en.InstallJetDescription=Repair Microsoft JET components
en.InstallProtectDriversDescription=Repair DATA BECKER copy protection drivers
en.DonateTxt=I want to donate something to the {#SupportUrl}

es.AppNotFoundMsg=web/shop to date 6, 7, 8 o 8s no se pudo encontrar en el sistema.%n%nLa instalacin de {#ProductName} {#FixName} ahora se cancelar.
es.AppIsInUseMsg=web/shop to date todava se est ejecutando.%n%nPara instalar de nuevo el programa, cirrelo y, a continuacin, haga clic en ACEPTAR.
;es.DeleteTempFolderGroupDescription=%nSe recomienda limpiar los directorios temporales en el sistema. Quieres que la instalacin de la revisin en hacer eso por usted ahora?%n

es.FixRuntimeErrorDescription=Fix error de ejecucin '-2147220502 (800403ea)': </head> invalid here
es.KillUpdateCheckerDescription=Retire completamente DATA BECKER UpdateChecker del sistema
es.DeleteTempFolderDescription=Limpie directorios temporales en el sistema
es.InstallVb6Description=Repare los componentes Microsoft Visual Basic 6 Runtime SP6
es.InstallMdacDescription=Repare los componentes de Microsoft Data Access (MDAC)
es.InstallJetDescription=Repare los componentes de Microsoft JET
es.InstallProtectDriversDescription=Reparar DATA BECKER copiar conductor de proteccin
es.DonateTxt=Quiero donar algo a la {#SupportUrl}

fr.AppNotFoundMsg=web/shop to date 6, 7, 8 ou 8s n'a pas pu tre trouv sur votre systme.%n%nL'installation de {#ProductName} {#FixName} est maintenant interrompue.
fr.AppIsInUseMsg=web/shop to date est en cours d'excution.%n%nPour rinstaller le logiciel veuillez fermer le programme et cliquez sur OK.
;fr.DeleteTempFolderGroupDescription=%nIl est recommand de nettoyer les rpertoires temporaires sur votre systme. Souhaitez-vous l'installation de correctifs pour le faire pour vous maintenant?%n

fr.FixRuntimeErrorDescription=Corriger l'erreur d'excution '-2147220502 (800403ea)': </head> invalid here
fr.KillUpdateCheckerDescription=Supprimer compltement DATA BECKER UpdateChecker du systme
fr.DeleteTempFolderDescription=Nettoyer les rpertoires temporaires sur le systme
fr.InstallVb6Description=Rparer les composants Microsoft Visual Basic 6 Runtime SP6
fr.InstallMdacDescription=Rparer les composants Microsoft Data Access (MDAC)
fr.InstallJetDescription=Rparer les composants Microsoft JET
fr.InstallProtectDriversDescription=Rparer le pilote anti-copie DATA BECKER
fr.DonateTxt=Je souhaite faire un don au {#SupportUrl}

nl.AppNotFoundMsg=web/shop to date 6, 7, 8 of 8s kon niet worden gevonden op uw systeem.%n%nDe installatie van {#ProductName} {#FixName} is nu geannuleerd.
nl.AppIsInUseMsg=web/shop to date is nog actief.%n%nOm de {#ProductName} {#FixName} te installeren, sluit u het programma en klik vervolgens op OK.
;nl.DeleteTempFolderGroupDescription=%nHet wordt aanbevolen om de temp directory op uw systeem op te schonen. Zal de hotfix setup dat nu voor u doen?%n

;nl.DeleteTempFolderDescription=JA, ik wil dat mijn temp mappen nu automatisch worden opgeschoond.

nl.FixRuntimeErrorDescription=Fix runtime error '-2147220502 (800403ea)': </head> invalid here
nl.KillUpdateCheckerDescription=Volledig verwijderen van de DATA BECKER UpdateChecker uit het systeem
nl.DeleteTempFolderDescription=Clean tijdelijke directory op het systeem
nl.InstallVb6Description=Microsoft Visual Basic 6 Runtime SP6 componenten repareren
nl.InstallMdacDescription=Reparatie Microsoft Data Access Components (MDAC)
nl.InstallJetDescription=Microsoft JET-onderdelen te repareren
nl.InstallProtectDriversDescription=Reparatie DATA BECKER kopieerbeveiliging drivers
nl.DonateTxt=Ik wil iets doneren aan de {#SupportUrl}

tr.AppNotFoundMsg=web/shop to date 6, 7, 8 veya 8s sisteminizde bulunamadi.%n%n{#ProductName} {#FixName} kurulum iptal edilecektir.
tr.AppIsInUseMsg=Bugne kadar web / dkkan su anda alisiyor.%n%n{#ProductName} {#FixName} Yklemek iin programi kapatin ve Tamam tiklayin.
;tr.DeleteTempFolderGroupDescription=%nBu sistem zerinde geici dizinleri temizlemek iin nerilir.Dzeltme kurulum sizin iin simdi bunu yapmak istiyor musunuz?%n

tr.FixRuntimeErrorDescription=Fix alisma zamani hatasi '-2147220502 (800403ea)': </head> invalid here
tr.KillUpdateCheckerDescription=Tamamen sistemden DATA BECKER UpdateChecker kaldirmak
tr.DeleteTempFolderDescription=Sistemde temiz geici dizinleri
tr.InstallVb6Description=Microsoft Visual Basic 6 Runtime SP6 bilesenlerini onarma
tr.InstallMdacDescription=Microsoft Data Access bilesenlerini tamir (MDAC)
tr.InstallJetDescription=Microsoft JET bilesenlerini onarma
tr.InstallProtectDriversDescription=Tamir DATA BECKER koruma srclerini kopya
tr.DonateTxt=Ben {#SupportUrl} bir sey bagislamak istiyorum

[LangOptions]
;LanguageName=German
;LanguageID=$0407
;LanguageCodePage=0
DialogFontName=Tahoma
DialogFontSize=8
WelcomeFontName=Verdana
WelcomeFontSize=13
TitleFontName=Verdana
TitleFontSize=32
CopyrightFontName=Tahoma
CopyrightFontSize=7

[Setup]
VersionInfoCompany={#Publisher}
VersionInfoCopyright= {#CurrentYear} by {#Publisher}
VersionInfoDescription={#ProductName} {#FixName} Setup
VersionInfoProductName={#ProductName} {#FixName}
VersionInfoTextVersion={#AppVersion}
VersionInfoVersion={#AppVersion}

AppCopyright= {#CurrentYear} by {#Publisher}
AppId={#ProductName} {#FixName}
;AppMutex={#AppMutex}
AppName={#ProductName} {#FixName}
AppPublisher={#Publisher}
AppPublisherURL=http://{#HomeUrl}
AppSupportURL=http://{#SupportUrl}
AppUpdatesURL=http://{#SupportUrl}
AppVerName={#ProductName} {#FixName} Version {#AppVersion}
AppVersion={#AppVersion}

CreateAppDir=no
ShowLanguageDialog=no
LanguageDetectionMethod=uilanguage
AlwaysRestart=no
RestartIfNeededByRun=no
PrivilegesRequired=admin
ChangesAssociations=yes

WizardImageFile=Data\Setup\Bitmaps\wz_large.bmp
WizardSmallImageFile=Data\Setup\Bitmaps\wz_small.bmp
WizardImageBackColor=clWhite
WizardImageStretch=yes

OutputBaseFilename={#OutputFileName}
OutputDir=.
Compression=lzma2/max
InternalCompressLevel=max
DiskSpanning=no
SolidCompression=no

FlatComponentsList=yes
ShowComponentSizes=yes
ShowTasksTreeLines=yes

DisableStartupPrompt=yes
DisableWelcomePage=no
DisableDirPage=yes
DisableProgramGroupPage=yes
DisableReadyMemo=no
DisableReadyPage=no
DisableFinishedPage=no

DirExistsWarning=no

AllowNoIcons=yes

Uninstallable=no

UsePreviousAppDir=no
UsePreviousGroup=no
UsePreviousLanguage=no
UsePreviousSetupType=no
UsePreviousTasks=no
UsePreviousUserInfo=no

CloseApplications=no

;InfoBeforeFile=Data\Setup\InfoBefore.txt
;InfoAfterFile=Data\Setup\InfoAfter.txt

;LicenseFile=Data\Setup\Lizenz.txt

SetupIconFile=Data\Setup\Icons\favicon.ico

#ifndef debugmode
  SignTool=vw
  SignToolRetryCount=10
#endif

[Languages]
Name: en; MessagesFile: compiler:Default.isl
Name: de; MessagesFile: compiler:Languages\German.isl
Name: es; MessagesFile: compiler:Languages\Spanish.isl
Name: fr; MessagesFile: compiler:Languages\French.isl
Name: nl; MessagesFile: compiler:Languages\Dutch.isl
Name: tr; MessagesFile: compiler:Languages\Turkish.isl

[Tasks]
#ifdef fixruntimeerror
  Name: fixruntimeerror; GroupDescription: {cm:AllGroupDescription}; Description: {cm:FixRuntimeErrorDescription}
#endif

#ifdef killupdatechecker
  Name: killupdatechecker; GroupDescription: {cm:AllGroupDescription}; Description: {cm:KillUpdateCheckerDescription}
#endif

#ifdef deletetempfolder
  Name: deletetempfolder; GroupDescription: {cm:AllGroupDescription}; Description: {cm:DeleteTempFolderDescription}
#endif

#ifdef cpdriver
  Name: installprotectdrivers; GroupDescription: {cm:AllGroupDescription}; Description: {cm:InstallProtectDriversDescription}; Flags: unchecked
#endif

#ifdef vbruntime6
  Name: installvb6; GroupDescription: {cm:AllGroupDescription}; Description: {cm:InstallVb6Description}; Flags: unchecked
#endif

#ifdef mdac28
  Name: installmdac; GroupDescription: {cm:AllGroupDescription}; Description: {cm:InstallMdacDescription}; Flags: unchecked
#endif

#ifdef jet40
  Name: installjet; GroupDescription: {cm:AllGroupDescription}; Description: {cm:InstallJetDescription}; Flags: unchecked
#endif

[Dirs]
;Name: {code:ws2d6InstPath}; Permissions: everyone-full; Check: ws2d6
;Name: {code:ws2d7InstPath}; Permissions: everyone-full; Check: ws2d7
;Name: {code:ws2d8InstPath}; Permissions: everyone-full; Check: ws2d8

;Name: {localappdata}\DATA BECKER\web to date 6.0; Permissions: everyone-full; Check: ws2d6
;Name: {localappdata}\DATA BECKER\web to date 7.0; Permissions: everyone-full; Check: ws2d7
;Name: {localappdata}\DATA BECKER\web to date 8.0; Permissions: everyone-full; Check: ws2d8

Name: {userdocs}\Erzeugte Websites; Permissions: everyone-full; Check: projectsdir_db_de
Name: {userdocs}\Built web sites; Permissions: everyone-full; Check: projectsdir_db_en
Name: {userdocs}\Sitios web creados; Permissions: everyone-full; Check: projectsdir_db_es
Name: {userdocs}\Sites Web crs; Permissions: everyone-full; Check: projectsdir_db_fr
Name: {userdocs}\Web siteleri; Permissions: everyone-full; Check: projectsdir_db_tr

Name: {userdocs}\web to date Projekte; Permissions: everyone-full; Check: createdir_db_de
Name: {userdocs}\web to date projects; Permissions: everyone-full; Check: createdir_db_en
Name: {userdocs}\Proyectos web to date; Permissions: everyone-full; Check: createdir_db_es
Name: {userdocs}\Projets web to date; Permissions: everyone-full; Check: createdir_db_fr
Name: {userdocs}\web to date projeleri; Permissions: everyone-full; Check: createdir_db_tr

Name: {userdocs}\SIQUANDO Web Projekte; Permissions: everyone-full; Check: createdir_sq_de

;Name: {code:GetTempPath}; Permissions: everyone-full
;Name: {win}\Temp; Permissions: everyone-full

[Files]
; Visual Basic Runtime
;Source: Data\Files\System\VB Runtime\stdole2.tlb; DestDir: {sys}; OnlyBelowVersion: 0,6; Flags: restartreplace regtypelib
;Source: Data\Files\System\VB Runtime\msvbvm60.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\oleaut32.dll; DestDir: {sys}; OnlyBelowVersion: 0,6; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\olepro32.dll; DestDir: {sys}; OnlyBelowVersion: 0,6; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\asycfilt.dll; DestDir: {sys}; OnlyBelowVersion: 0,6; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\comcat.dll; DestDir: {sys}; OnlyBelowVersion: 0,6; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\vb6de.dll; DestDir: {sys}; Flags: restartreplace

; DAO and JET
;Source: Data\Files\System\VB Runtime\expsrv.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msjint35.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msjter35.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\vb5db.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\vbajet32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msrepl35.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msrd2x35.dll; DestDir: {sys}; Flags: regserver restartreplace
;Source: Data\Files\System\VB Runtime\msjet35.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\dao350.dll; DestDir: {dao}; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\Dao2535.tlb; DestDir: {dao}; Flags: restartreplace regtypelib noregerror

; Common Controls
;Source: Data\Files\System\VB Runtime\mscmcde.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\mscomctl.ocx; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\msstdfmt.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\VB Runtime\mscc2de.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\mscomct2.ocx; DestDir: {sys}; Flags: restartreplace regserver

; Common Dialog
;Source: Data\Files\System\VB Runtime\cmdlgde.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\comdlg32.ocx; DestDir: {sys}; Flags: regserver restartreplace

; Flexgrid
;Source: Data\Files\System\VB Runtime\flxgdde.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msflxgrd.ocx; DestDir: {sys}; Flags: restartreplace regserver

; Inet
;Source: Data\Files\System\VB Runtime\inetde.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\VB Runtime\msinet.ocx; DestDir: {sys}; Flags: restartreplace regserver

; LeadTools 12
;Source: Data\Files\System\LeadTools\lfbmp12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\lfcmp12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\lfgif12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltdis12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltefx12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltfil12n.DLL; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltimg12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltkrn12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\lttwn12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\ltann12n.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\msvcrt.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\LeadTools\mfc42.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\LeadTools\ltocx12n.ocx; DestDir: {sys}; Flags: restartreplace regserver

; Mabry
;Source: Data\Files\System\Mabry\EncodeX.ocx; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\FtpX.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\FtpX.ocx; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\MabryObj.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\MimeX.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\PopX.dll; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\PopX.ocx; DestDir: {sys}; Flags: restartreplace regserver
;Source: Data\Files\System\Mabry\EncodeX.dll; DestDir: {sys}; Flags: restartreplace regserver

; TX TextControl
;Source: Data\Files\System\TX Textcontrol\tx_rtf32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\tx_tif32.flt; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\tx_wmf32.flt; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\tx_word.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\txobj32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\txtls32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\wndtls32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\ic32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\ic32.ini; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\Tx32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\tx_bmp32.flt; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\tx_htm32.dll; DestDir: {sys}; Flags: restartreplace
;Source: Data\Files\System\TX Textcontrol\Tx4ole.ocx; DestDir: {sys}; Flags: regserver restartreplace

; Schreibgeschtzte Dateien nach {cf}\DATA BECKER Shared, um Neuaktivierung des UCs zu verhindern
#ifdef killupdatechecker
  Source: Data\Files\DBshared\*; DestDir: {cf}\{cm:SharedDirName}; Flags: ignoreversion overwritereadonly uninsneveruninstall restartreplace; Attribs: readonly hidden; Tasks: killupdatechecker; BeforeInstall: KillUpdateChecker()
#endif

; vom Setup bentigte Dateien
;Source: Data\Setup\Bitmaps\logo.bmp; Flags: dontcopy
Source: Data\Setup\Skins\ISSkin.dll; Flags: dontcopy
Source: Data\Setup\Skins\{#StylesFile}; Flags: dontcopy

;Source: Data\Setup\Bitmaps\bbrd1.bmp; Flags: dontcopy

#ifdef cpdriver
;  Source: Data\Redist\Driver_Setup.exe; Flags: dontcopy; Tasks: installprotectdrivers
  Source: Data\Redist\PDLicHelperSetup.exe; Flags: dontcopy; Tasks: installprotectdrivers
  Source: Data\Redist\mpDRM.exe; Flags: dontcopy; Tasks: installprotectdrivers; Check: ws2d7el8fe
#endif

#ifdef vbruntime6
  Source: Data\Redist\vbrun60sp6.exe; DestDir: {tmp}; Flags: deleteafterinstall; Tasks: installvb6; AfterInstall: InstallVbRuntime6()
#endif

#ifdef mdac28
  Source: Data\Redist\mdac_typ.exe; DestDir: {tmp}; Flags: deleteafterinstall; Tasks: installmdac; AfterInstall: InstallMdac28()
#endif

#ifdef jet40
  Source: Data\Redist\Jet40SP8_9xNT.exe; DestDir: {tmp}; Flags: deleteafterinstall; Tasks: installjet; AfterInstall: InstallJet40()
#endif

[Registry]
; UpdateChecker-Keys aus Registry lschen
#ifdef killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\DATA BECKER\Update; Flags: deletekey; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:UpdateExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:ServiceExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:UninstExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:UpdateExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:ServiceExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\SharedDLLs; ValueName: {cf}\{cm:SharedDirName}\{cm:UninstExe}; Flags: deletevalue; Tasks: killupdatechecker
  Root: HKLM; SubKey: SYSTEM\ControlSet001\services\DBService; Flags: deletekey; Tasks: killupdatechecker
  Root: HKLM; SubKey: SYSTEM\ControlSet002\services\DBService; Flags: deletekey; Tasks: killupdatechecker
  Root: HKLM; SubKey: SYSTEM\CurrentControlSet\services\DBService; Flags: deletekey; Tasks: killupdatechecker
#endif

; Kompatibilitts-Flag fr Vista/7/8/8.1 setzen
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d6InstPath}\web2date.exe; ValueData: $00000002; Check: ws2d6 and w2d
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d7InstPath}\web2date.exe; ValueData: $00000002; Check: ws2d7 and w2d
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d8InstPath}\web2date.exe; ValueData: $00000002; Check: ws2d8 and w2d

Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d6InstPath}\shop2date.exe; ValueData: $00000002; Check: ws2d6 and s2d
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d7InstPath}\shop2date.exe; ValueData: $00000002; Check: ws2d7 and s2d
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d8InstPath}\shop2date.exe; ValueData: $00000002; Check: ws2d8 and s2d

Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d6InstPath}\{cm:DBstartFile}; ValueData: $00000002; Check: ws2d6
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d7InstPath}\{cm:DBstartFile}; ValueData: $00000002; Check: ws2d7
Root: HKCU; SubKey: Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Compatibility Assistant\Persisted; ValueType: dword; ValueName: {code:ws2d8InstPath}\{cm:DBstartFile}; ValueData: $00000002; Check: ws2d8

; Behebung des Laufzeitfehlers beim Start
#ifdef fixruntimeerror
  Root: HKCU; Subkey: Software\DATA BECKER\web to date; ValueType: dword; ValueName: AddInUpdateMode; ValueData: 2; Tasks: fixruntimeerror; Check: ws2d6
  Root: HKCU; Subkey: Software\DATA BECKER\web to date 7.0; ValueType: dword; ValueName: AddInUpdateMode; ValueData: 2; Tasks: fixruntimeerror; Check: ws2d7
  Root: HKCU; Subkey: Software\DATA BECKER\web to date 8.0; ValueType: dword; ValueName: AddInUpdateMode; ValueData: 2; Tasks: fixruntimeerror; Check: ws2d8
#endif

; ### Keys zur Behebung des Binary Planting Exploits ###
;Root: HKLM; SubKey: SYSTEM\CurrentControlSet\Control\Session Manager; ValueType: dword; ValueName: CWDIllegalInDllSearch; ValueData: $ffffffff
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\web2date.exe; ValueType: dword; ValueName: CWDIllegalInDllSearch; ValueData: $ffffffff; Check: w2d
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\shop2date.exe; ValueType: dword; ValueName: CWDIllegalInDllSearch; ValueData: $ffffffff; Check: s2d
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\SiteSwitch.exe; ValueType: dword; ValueName: CWDIllegalInDllSearch; ValueData: $ffffffff

; Aufhebung der 20-Tage-Gltigkeit der erzeugten Website
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8D; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8          
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8F; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8wt          
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8E; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8mu  
      
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B92; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8pro          
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B94; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8prowt         
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B93; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8promu 
     
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8D; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8s      
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8F; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8swt         
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B8E; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8smu   
       
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B92; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8spro         
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B94; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8sprowt        
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B93; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8spromu   

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B90; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8el
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002B95; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d8el       

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9A; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8en
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9B; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8wten
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9C; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8muen

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9D; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8fr
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9E; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8wtfr
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00002D9F; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d8mufr

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00000F38; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00000F73; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6wt  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00000F74; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6mu 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00000F94; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6anwaelte  
 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00000F39; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d6pro  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001007; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d6prowt 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001006; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d6promu  

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001043; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: dls2d8pro  

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001220; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6en   
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\0000157E; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6fr  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000014AF; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6tr 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\0000166D; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d6se  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\0000166E; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d6prose 

;Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\0000169C; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: ws2d6seaddon  

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017AE; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017F6; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7wt  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017F7; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7mu 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017F8; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7anwaelte  

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017AF; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d7pro 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017F9; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d7prowt  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017FA; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d7promu  

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000017FB; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: dls2d7pro 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000019F2; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7ba   
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000019D9; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d7ba

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001A01; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7el  
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001A65; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d7el 
 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001A36; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7en 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001AFF; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7es 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001A57; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7fr 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001B0B; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7wten   
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001B0A; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7muen 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001C95; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7wtfr 
Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\00001C94; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: w2d7mufr 

Root: HKCU; Subkey: Software\Protect Software GmbH\ProtectDisc\000035DE; ValueType: string; ValueName: STARTUP; ValueData: PDLCSSAAAAABAGHLJXTEECPCRYVXWYWMDGYQKYGXIS; Flags: uninsdeletevalue; Check: s2d6proes

; Wiederherstellung w2d Registry-Zweig unter HKLM (falls nicht mehr existent)
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date; ValueType: string; ValueName: InstallPath; ValueData: {code:ws2d6InstPath}; Flags: createvalueifdoesntexist; Check: ws2d6
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date; ValueType: string; ValueName: UserUID; ValueData: {code:GetUserUID}; Flags: createvalueifdoesntexist; Check: ws2d6
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date; ValueType: string; ValueName: Version; ValueData: 600; Flags: createvalueifdoesntexist; Check: ws2d6
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date\6.0; ValueType: string; Flags: createvalueifdoesntexist; Check: ws2d6

Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 7.0; ValueType: string; ValueName: InstallPath; ValueData: {code:ws2d7InstPath}; Flags: createvalueifdoesntexist; Check: ws2d7
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 7.0; ValueType: string; ValueName: UserUID; ValueData: {code:GetUserUID}; Flags: createvalueifdoesntexist; Check: ws2d7
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 7.0; ValueType: string; ValueName: Version; ValueData: 700; Flags: createvalueifdoesntexist; Check: ws2d7

Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 8.0; ValueType: string; ValueName: InstallPath; ValueData: {code:ws2d8InstPath}; Flags: createvalueifdoesntexist; Check: ws2d8
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 8.0; ValueType: string; ValueName: UserUID; ValueData: {code:GetUserUID}; Flags: createvalueifdoesntexist; Check: ws2d8
Root: HKLM; Subkey: SOFTWARE\DATA BECKER\web to date 8.0; ValueType: string; ValueName: Version; ValueData: 800; Flags: createvalueifdoesntexist; Check: ws2d8

[Run]
#ifdef cpdriver
;  Filename: {code:CSP1}\Driver_Setup.exe; Parameters: /S; Flags: waituntilterminated; StatusMsg: {cm:InstallCpDrivers}; WorkingDir: {code:CSP1}; Tasks: installprotectdrivers
  Filename: {code:CSP2}\PDLicHelperSetup.exe; Parameters: /S; Flags: waituntilterminated; StatusMsg: {cm:InstallCpDrivers}; WorkingDir: {code:CSP2}; Tasks: installprotectdrivers
  Filename: {code:CSP3}\mpDRM.exe; Parameters: /S; Flags: waituntilterminated; StatusMsg: {cm:InstallCpDrivers}; WorkingDir: {code:CSP3}; Tasks: installprotectdrivers; Check: ws2d7el8fe
#endif

#ifdef DonateUrl
  Filename: {#DonateUrl}; Description: {cm:DonateTxt}; Flags: postinstall nowait shellexec
#endif

[InstallDelete]
Name: {pf}\ProtectDisc; Type: dirifempty

#ifdef deletetempfolder
  Name: {code:GetTempPath}\*; Type: filesandordirs; Tasks: deletetempfolder
  Name: {win}\Temp\*; Type: filesandordirs; Tasks: deletetempfolder
#endif

#ifdef killupdatechecker
  Name: {cf}\{cm:SharedDirName}\{cm:UpdateExe}; Type: files; Tasks: killupdatechecker
  Name: {cf}\{cm:SharedDirName}\{cm:ServiceExe}; Type: files; Tasks: killupdatechecker
  Name: {cf}\{cm:SharedDirName}\{cm:UninstExe}; Type: files; Tasks: killupdatechecker
#endif

[Code]
var
  ErrorCode: Integer;
  FileVersion: String;
  CommonFilesDir: String;
  OSVersionsNumber: String;
  OSVersion: TWindowsVersion;
  ProgressPage: TOutputProgressWizardPage;
  PrintButton: TButton;
  FinishedInstall: Boolean;

//  BbrdBitmapImage: TBitmapImage;

//  BmpFileName: String;
//  BackgroundBitmapImage: TBitmapImage;

//  BbrdImageFrm: TForm;
//  SWPos: Integer;
//  BbrdCount: Integer;
//  BbrdPos: Integer;
//  BbrdSwitchPos: Integer;

//  mpOrgHeight: Integer;

//  LogoImageName: String;
//  LogoImage: TBitmapImage;

procedure LoadSkin(lpszPath: String; lpszIniFileName: String);
external 'LoadSkin@files:ISSkin.dll stdcall';

procedure UnloadSkin();
external 'UnloadSkin@files:ISSkin.dll stdcall';

function ShowWindow(hWnd: Integer; uType: Integer): Integer;
external 'ShowWindow@user32.dll stdcall';

procedure PrintButtonClick(Sender : TObject);
var
  LicenseText: String;
  RetCode    : Integer;
begin
  if (MsgBox(ExpandConstant('{cm:TxtLicensePrintOnDefaultPrinter}'), mbConfirmation, MB_YESNO ) = IDYES) then begin
    LicenseText := WizardForm.LicenseMemo.Text;
    SaveStringToFile(ExpandConstant('{tmp}\license.rtf'), LicenseText, False);
    if (FileExists(ExpandConstant('{tmp}\license.rtf')) = True) then begin
      if (ShellExec('print', ExpandConstant('{tmp}\license.rtf'), '', '', SW_HIDE, ewWaitUntilTerminated, RetCode) = False) then begin
        MsgBox(ExpandConstant('{cm:TxtLicensePrintFailed}'), mbError, MB_OK)
      end;
    end else begin
      MsgBox(ExpandConstant('{cm:TxtLicenseExtractFailed}'), mbError, MB_OK);
    end;
  end;
end;

//procedure BbrdImageFrmClick(Sender : TObject);
//begin
//  WizardForm.BringtoFront;
//  WizardForm.BringtoFront;
//  WizardForm.Focused;
//end;

//procedure ShowBbrd(Pause: string);
//var
//  Pos: Integer;
//  P  : Integer;
//begin
//  if (BbrdCount > 0) then begin
//    Pos := WizardForm.ProgressGauge.Position;
//    if ((BbrdSwitchPos = 0) or (Pos >= BbrdSwitchPos)) then begin

//      if (BbrdSwitchPos = 0) then begin
//        SWPos := WizardForm.ProgressGauge.Max div BbrdCount;
//      end;
//      BbrdSwitchPos := BbrdSwitchPos + SWPos;

//      BbrdPos := BbrdPos + 1;
//      BmpFileName := 'Bbrd' + IntToStr(BbrdPos) + '.bmp';

//      if (FileExists(ExpandConstant('{tmp}\') + BmpFileName) = False) then ExtractTemporaryFile(ExtractFileName(BmpFileName));
//      BbrdBitmapImage.Bitmap.LoadFromFile(ExpandConstant('{tmp}\') + BmpFileName);
//      BbrdBitmapImage.Refresh;
//      P := StrToInt(Pause);
//      if (P > 0) then sleep(P*1000);

//    end;
//  end;
//end;

procedure InitializeWizard();
//var
//  BHeight: Integer;
begin
//  BbrdCount := StrToInt(ExpandConstant('{cm:BillBoardCount}'));
//  BbrdSwitchPos := 0;
//  BbrdPos := 0;

  WizardForm.ReadyMemo.Color := clWhite;

//  LogoImageName := ExpandConstant('{tmp}\logo.bmp');

//  if FileExists(LogoImageName) = False then begin
//    ExtractTemporaryFile(ExtractFileName(LogoImageName));
//  end;

//  LogoImage := TBitmapImage.Create(WizardForm);
//  LogoImage.Align := alNone;
//  LogoImage.Top := WizardForm.Height - 71;
//  LogoImage.Left := 3;
//  LogoImage.Width := 220;
//  LogoImage.Height := 40;
//  LogoImage.Stretch := False;
//  LogoImage.Bitmap.LoadFromFile(LogoImageName);
//  LogoImage.Parent := WizardForm;

end;

procedure CurPageChanged(CurPageID: Integer);
begin
  case CurPageID of
    wpWelcome: begin
//      LogoImage.Visible := False;
    end;
    wpLicense: begin
//      LogoImage.Visible := True;
    end;
    wpPassword: begin
//      LogoImage.Visible := True;
    end;
    wpInfoBefore: begin
//      LogoImage.Visible := True;
    end;
    wpUserInfo: begin
//      LogoImage.Visible := True;
    end;
    wpSelectDir: begin
//      LogoImage.Visible := True;
    end;
    wpSelectComponents: begin
//      LogoImage.Visible := True;
    end;
    wpSelectProgramGroup: begin
//      LogoImage.Visible := True;
    end;
    wpSelectTasks: begin
//      LogoImage.Visible := True;
    end;
    wpReady: begin
//      LogoImage.Visible := True;
    end;
    wpPreparing: begin
//      LogoImage.Visible := True;
    end;
    wpInstalling: begin
//      LogoImage.Visible := True;

//      mpOrgHeight := WizardForm.MainPanel.Height;
//      WizardForm.MainPanel.Height := 254;
//      WizardForm.MainPanel.Width := WizardForm.MainPanel.Width;
//      WizardForm.MainPanel.Left := 0;
//      WizardForm.PageNameLabel.Visible := False;
//      WizardForm.PageDescriptionLabel.Visible := False;
//      WizardForm.WizardSmallBitmapImage.Visible := False;
//      WizardForm.MainPanel.Color := $f0f0f0;

//      BbrdBitmapImage         := TBitmapImage.Create(WizardForm.MainPanel);
//      BbrdBitmapImage.Align   := alNone; //alClient;
//      BbrdBitmapImage.Stretch := True;
//      BbrdBitmapImage.Center  := True;
//      BbrdBitmapImage.Top     := 5;
//      BbrdBitmapImage.Left    := 40;
//      BbrdBitmapImage.Width   := WizardForm.InstallingPage.Width;
//      BbrdBitmapImage.Height  := WizardForm.InstallingPage.Height;
//      BbrdBitmapImage.Parent  := WizardForm.MainPanel;

//      WizardForm.ProgressGauge.Top := 211;
//      WizardForm.StatusLabel.Top := WizardForm.ProgressGauge.Top - 32;
//      WizardForm.FilenameLabel.Top := WizardForm.ProgressGauge.Top - 16;
//      WizardForm.Bevel1.Visible := False;

//      WizardForm.NextButton.Top := WizardForm.CancelButton.Top;
//      WizardForm.NextButton.Left := WizardForm.CancelButton.Left;
    end;
    wpInfoAfter: begin
//      LogoImage.Visible := True;
//      BbrdBitmapImage.Free;
//      BbrdBitmapImage.Visible := False;
//      WizardForm.MainPanel.Height := mpOrgHeight;
//      WizardForm.Bevel1.Visible := True;
//      WizardForm.PageNameLabel.Visible := True;
//      WizardForm.PageDescriptionLabel.Visible := True;
    end;
    wpFinished: begin
//      LogoImage.Visible := False;
//      WizardForm.BackButton.Visible := False;
    end;
  end;
end;

// Abfrage, ob System gebootet werden mu
//function NeedRestart: Boolean;
//begin
//  if (FileExists(ExpandConstant('{cf}\{cm:SharedDirName}\DBuninst.exe')) = True) then begin
//    Result := True;
//  end else begin
//    Result := False;
//  end;
//end;

function GetCustomSetupExitCode: Integer;
begin
  RegDeleteValue(HKCU, 'SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce', 'SetupStart');
  RegDeleteValue(HKCU, 'SOFTWARE\DATA BECKER', 'UserConfCompInst');
  DelTree(ExpandConstant('{win}\TEMP\dao'), True, True, True);
end;

//function NextButtonClick(CurPageID: Integer): Boolean;
//begin

//  if (CurPageID = wpWelcome) then begin

// Lizenztext drucken
//    PrintButton         := TButton.Create(WizardForm);
//    PrintButton.Caption := ExpandConstant('{cm:TxtLicensePrintButton}');
//    PrintButton.Width   := Length(PrintButton.Caption) * 5 + 8;
//    PrintButton.Left    := WizardForm.LicenseMemo.Left + WizardForm.LicenseMemo.Width - PrintButton.Width;
//    PrintButton.Top     := WizardForm.LicenseMemo.Top + WizardForm.LicenseMemo.Height + 16;
//    PrintButton.OnClick := @PrintButtonClick;
//    PrintButton.Parent  := WizardForm.LicenseAcceptedRadio.Parent;

//  end;

//  if (CurPageID = wpReady) then begin

// GetOSversion
//    GetWindowsVersionEx(OSVersion);
//    OSVersionsNumber := IntToStr(OSVersion.Major) + '.' + IntToStr(OSVersion.Minor);

//    ProgressPage := CreateOutputProgressPage(ExpandConstant('{cm:InstallMsg1}'), ExpandConstant('{cm:InstallMsg2}'));
//    ProgressPage.SetProgress(0, 3);
//    ProgressPage.Show;

//#ifdef vbruntime6
//    GetVersionNumbersString(ExpandConstant('{sys}\msvbvm60.dll'), FileVersion);
//    if (FileVersion < '6.0.97.82') then begin
//      ProgressPage.SetText(ExpandConstant('{cm:InstallVB6Rt}'), '');
//      ProgressPage.SetProgress(1, 3);
//      ExtractTemporaryFile('vbrun60sp6.exe');
//      ShellExec('open', ExpandConstant('{tmp}\vbrun60sp6.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
//      DeleteFile(ExpandConstant('{tmp}\vbrun60sp6.exe'));
//    end;
//#endif

//#ifdef mdac28
//    RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion', 'CommonFilesDir', CommonFilesDir)
//    GetVersionNumbersString(CommonFilesDir + '\SYSTEM\ole db\Oledb32.dll', FileVersion);
//    if ((FileVersion < '2.80.1022.0') or (FileExists(CommonFilesDir + '\SYSTEM\ole db\Oledb32.dll') = False)) then begin
//      ProgressPage.SetText(ExpandConstant('{cm:InstallMDAC2_8}'), '');
//      ProgressPage.SetProgress(2, 3);
//      ExtractTemporaryFile('mdac_typ.exe');
//      ShellExec('open', ExpandConstant('{tmp}\mdac_typ.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
//      DeleteFile(ExpandConstant('{tmp}\mdac_typ.exe'));
//    end;
//#endif

//#ifdef jet40
//    if (FileExists(ExpandConstant('{sys}\msjet40.dll')) = True) then begin
//      GetVersionNumbersString(ExpandConstant('{sys}\msjet40.dll'), FileVersion);
//      if (FileVersion < '4.0.8015.0') then begin
//        ProgressPage.SetText(ExpandConstant('{cm:InstallJET4_0}'), '');
//        ProgressPage.SetProgress(3, 3);
//        ExtractTemporaryFile('Jet40SP8_9xNT.exe');
//        ShellExec('open', ExpandConstant('{tmp}\Jet40SP8_9xNT.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
//        DeleteFile(ExpandConstant('{tmp}\Jet40SP8_9xNT.exe'));
//      end;
//    end;
//#endif

//    ProgressPage.Hide;

//  end;

//  Result := True;

//end;

//function GetDate(Default: String): String;
//begin
//  Result := GetDateTimeString('dd/mm/yyyy', '.', #0);
//end;

function InitializeUninstall(): Boolean;
begin
  while (CheckForMutexes('DATA BECKER Start Browser') = True) do begin
    if MsgBox('Der ' + ExpandConstant('{cm:DBstartTxt}') + ' wird gerade ausgefhrt.' + #13#10#13#10 + 'Um {#ProductName} zu deinstallieren, schlieen Sie bitte den ' + ExpandConstant('{cm:DBstartTxt}') + ' und klicken Sie anschlieend auf OK.', mbCriticalError, MB_OKCANCEL) = IDCANCEL then begin
      Result := False;
      Exit;
    end;
  end;
  Result := True;
end;

function CSP1(Default: String): string;
begin
  ExtractTemporaryFile('Driver_Setup.exe');
  Result := ExpandConstant('{tmp}');
end;

function CSP2(Default: String): string;
begin
  ExtractTemporaryFile('PDLicHelperSetup.exe');
  Result := ExpandConstant('{tmp}');
end;

function CSP3(Default: String): string;
begin
  ExtractTemporaryFile('mpDRM.exe');
  Result := ExpandConstant('{tmp}');
end;

// Prfen, ob ProtectDisc Driver 11.0.0.14 bereits vorhanden ist und falls JA, nicht erneut installieren, um unntige Neustartaufforderung nach Setup zu vermeiden
function IsPD110014(): Boolean;
var
  ProtectVersion: String;
begin
  if (IsWin64 = True) then begin
    ProtectVersion := '';
    RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ProtectDisc Driver 11', 'DisplayVersion', ProtectVersion);
    if (ProtectVersion = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\ProtectDisc Driver 11', 'DisplayVersion', ProtectVersion);
    if (ProtectVersion < '11.0.0.14') then Result := True else Result := False;
  end else begin
    if (FileExists(ExpandConstant('{sys}\drivers\acedrv11.sys')) = True) then begin
      GetVersionNumbersString(ExpandConstant('{sys}\drivers\acedrv11.sys'), FileVersion);
      if (FileVersion < '11.0.0.14') then Result := True else Result := False;
    end else Result := True;
  end;
end;

// Wenn irgendein web/shop to date 6.0 installiert ist, Installationspfad auslesen
function ws2d6InstPath(Default: String): String;
var
  Path: String;
begin
  Path := '';
  RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro - Sommer Edition', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\Downloadshop to date 6.0 pro', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 FR', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date Trkiye', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 - Sommer Edition', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 fr Anwlte', 'InstallPath', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro - Sommer Edition_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Downloadshop to date 6.0 pro_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 FR_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date Trkiye_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 - Sommer Edition_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 fr Anwlte_is1', 'Inno Setup: App Path', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 6.0 pro - Sommer Edition_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Downloadshop to date 6.0 pro_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 FR_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date Trkiye_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 - Sommer Edition_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 6.0 fr Anwlte_is1', 'InstallLocation', Path);
  Result := RemoveBackslashUnlessRoot(Path);
end;

// Wenn irgendein web/shop to date 7 installiert ist, Installationspfad auslesen
function ws2d7InstPath(Default: String): String;
var
  Path: String;
begin
  Path := '';
  RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7.0', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 basic', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser FR', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel FR', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 ES', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 FR', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 basic', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements ES', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements FR', 'InstallPath', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 basic_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser FR_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel FR_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 ES_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 FR_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 basic_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements ES_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements FR_is1', 'Inno Setup: App Path', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 pro_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 basic_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 MultiUser FR_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 Work & Travel FR_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 ES_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 FR_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 basic_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements ES_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements FR_is1', 'InstallLocation', Path);
  Result := RemoveBackslashUnlessRoot(Path);
end;

// Wenn irgendein web/shop to date 8 installiert ist, Installationspfad auslesen
function ws2d8InstPath(Default: String): String;
var
  Path: String;
begin
  Path := '';
  RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8.0', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 first edition', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 MultiUser', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 Work & Travel', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 FR', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 first edition', 'InstallPath', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 first edition_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 MultiUser_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 Work & Travel_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 FR_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 first edition_is1', 'Inno Setup: App Path', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8s pro_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 pro_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 first edition_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 MultiUser_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 Work & Travel_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8s_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 FR_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 first edition_is1', 'InstallLocation', Path);
  Result := RemoveBackslashUnlessRoot(Path);
end;

// Wenn irgendein w2d/s2d 7 elements oder 8 first edition installiert ist, Installationspfad auslesen
function ws2d7el8feInstPath(Default: String): String;
var
  Path: String;
begin
  Path := '';
  RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 first edition', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 first edition', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements EN', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements ES', 'InstallPath', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements FR', 'InstallPath', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 first edition_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 first edition_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements EN_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements ES_is1', 'Inno Setup: App Path', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements FR_is1', 'Inno Setup: App Path', Path);

  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 8 first edition_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 8 first edition_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\shop to date 7 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements EN_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements ES_is1', 'InstallLocation', Path);
  if (Path = '') then RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\web to date 7 elements FR_is1', 'InstallLocation', Path);
  Result := RemoveBackslashUnlessRoot(Path);
end;

// Feststellen, ob web/shop to date 6.0 installiert ist
function ws2d6(): Boolean;
begin
  if (ws2d6InstPath('') = '') then Result := False else Result := True;
end;

// Feststellen, ob web/shop to date 7 installiert ist
function ws2d7(): Boolean;
begin
  if (ws2d7InstPath('') = '') then Result := False else Result := True;
end;

// Feststellen, ob web/shop to date 8 installiert ist
function ws2d8(): Boolean;
begin
  if (ws2d8InstPath('') = '') then Result := False else Result := True;
end;

// Feststellen, ob irgendein web/shop to date 7 elements oder 8 first edition installiert ist
function ws2d7el8fe(): Boolean;
begin
  if (ws2d7el8feInstPath('') = '') then Result := False else Result := True;
end;

// Feststellen, ob web to date installiert ist
function w2d(): Boolean;
var
  ws2d6Path, ws2d7Path, ws2d8Path: String;
begin
  ws2d6Path := ws2d6InstPath('');
  ws2d7Path := ws2d7InstPath('');
  ws2d8Path := ws2d8InstPath('');
  if (((ws2d6 = True) and (FileExists(ws2d6Path + '\web2date.exe') = True)) or ((ws2d7 = True) and (FileExists(ws2d7Path + '\web2date.exe') = True)) or ((ws2d8 = True) and (FileExists(ws2d8Path + '\web2date.exe') = True))) then Result := True else Result := False;
end;

// Feststellen, ob shop to date installiert ist
function s2d(): Boolean;
var
  ws2d6Path, ws2d7Path, ws2d8Path: String;
begin
  ws2d6Path := ws2d6InstPath('');
  ws2d7Path := ws2d7InstPath('');
  ws2d8Path := ws2d8InstPath('');
  if (((ws2d6 = True) and (FileExists(ws2d6Path + '\shop2date.exe') = True)) or ((ws2d7 = True) and (FileExists(ws2d7Path + '\shop2date.exe') = True)) or ((ws2d8 = True) and (FileExists(ws2d8Path + '\shop2date.exe') = True))) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 installiert ist
function w2d6(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 Work & Travel installiert ist
function w2d6wt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 MultiUser installiert ist
function w2d6mu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 fr Anwlte installiert ist
function w2d6anwaelte(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 fr Anwlte', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 6 pro installiert ist
function s2d6pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 6 pro Work & Travel installiert ist
function s2d6prowt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 6 pro MultiUser installiert ist
function s2d6promu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob Downloadshop to date 6 pro installiert ist
function dls2d6pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\Downloadshop to date 6.0 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 EN installiert ist
function w2d6en(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 FR installiert ist
function w2d6fr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 Sommer Edition installiert ist
function w2d6se(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 - Sommer Edition', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 6 pro Sommer Edition installiert ist
function s2d6prose(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro - Sommer Edition', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 6 Trkyie installiert ist
function w2d6tr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 6.0 Trkiye', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 6 pro ES installiert ist
function s2d6proes(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 6.0 pro ES', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 elements installiert ist
function w2d7el(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 elements', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 basic installiert ist
function w2d7ba(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 basic', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 installiert ist
function w2d7(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 fr Anwlte installiert ist
function w2d7anwaelte(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 fr Anwlte', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 Work & Travel installiert ist
function w2d7wt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 MultiUser installiert ist
function w2d7mu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 7 elements installiert ist
function s2d7el(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 elements', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 7 basic installiert ist
function s2d7ba(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 basic', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 7 pro installiert ist
function s2d7pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 7 pro Work & Travel installiert ist
function s2d7prowt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 7 pro MultiUser installiert ist
function s2d7promu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 7 pro MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob Downloadshop to date 7 pro installiert ist
function dls2d7pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\Downloadshop to date 7 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 EN installiert ist
function w2d7en(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 ES installiert ist
function w2d7es(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 ES', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 FR installiert ist
function w2d7fr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 Work & Travel EN installiert ist
function w2d7wten(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 MultiUser EN installiert ist
function w2d7muen(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 Work & Travel FR installiert ist
function w2d7wtfr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 Work & Travel FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 7 MultiUser FR installiert ist
function w2d7mufr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 7 MultiUser FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 installiert ist
function w2d8(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 Work & Travel installiert ist
function w2d8wt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 MultiUser installiert ist
function w2d8mu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8 pro installiert ist
function s2d8pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8 pro Work & Travel installiert ist
function s2d8prowt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8 pro MultiUser installiert ist
function s2d8promu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 pro MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 EN installiert ist
function w2d8en(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 Work & Travel EN installiert ist
function w2d8wten(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 Work & Travel EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 MultiUser EN installiert ist
function w2d8muen(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 MultiUser EN', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 FR installiert ist
function w2d8fr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 Work & Travel FR installiert ist
function w2d8wtfr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 Work & Travel FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 MultiUser FR installiert ist
function w2d8mufr(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 MultiUser FR', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8 elements installiert ist
function w2d8el(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8 elements', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8 elements installiert ist
function s2d8el(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8 elements', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8s installiert ist
function w2d8s(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8s Work & Travel installiert ist
function w2d8swt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob web to date 8s MultiUser installiert ist
function w2d8smu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\web to date 8s MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8s pro installiert ist
function s2d8spro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8s pro Work & Travel installiert ist
function s2d8sprowt(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro Work & Travel', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob shop to date 8s pro MultiUser installiert ist
function s2d8spromu(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\shop to date 8s pro MultiUser', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob Downloadshop to date 8 pro installiert ist
function dls2d8pro(): Boolean;
begin
  if (RegValueExists(HKLM, 'SOFTWARE\DATA BECKER\Downloadshop to date 8 pro', 'InstallPath') = True) then Result := True else Result := False;
end;

// Feststellen, ob eine deutsche shop to date 8/8s Vollversion installiert ist
//function s2d8full(): Boolean;
//begin
//  if ((s2d8pro = True) or (s2d8prowt = True) or (s2d8promu = True) or (s2d8spro = True) or (s2d8sprowt = True) or (s2d8spromu = True)) then Result := True else Result := False;
//end;

// Feststellen, ob das Plugin Jetzt kaufen installiert ist
//function buynow(): Boolean;
//var Path: String;
//begin
//  Path := AppInstPath('');
//  if (FileExists(Path + '\plugins\W2DPluginBuyNow8.dll') = True) then Result := True else Result := False;
//end;

// Prfen, ob das w2d/s2d [DE] Erstellungs-Verzeichnis "{userdocs}\Erzeugte Websites" existent ist
function projectsdir_db_de(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Erzeugte Websites')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [EN] Erstellungs-Verzeichnis "{userdocs}\Built web sites" existent ist
function projectsdir_db_en(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Built web sites')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [ES] Erstellungs-Verzeichnis "{userdocs}\Sitios web creados" existent ist
function projectsdir_db_es(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Sitios web creados')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [FR] Erstellungs-Verzeichnis "{userdocs}\Sites Web crs" existent ist
function projectsdir_db_fr(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Sites Web crs')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [TR] Erstellungs-Verzeichnis "{userdocs}\Web siteleri" existent ist
function projectsdir_db_tr(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Web siteleri')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [DE] Projekt-Verzeichnis "{userdocs}\web to date Projekte" existent ist
function createdir_db_de(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\web to date Projekte')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [EN] Projekt-Verzeichnis "{userdocs}\web to date projects" existent ist
function createdir_db_en(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\web to date projects')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [ES] Projekt-Verzeichnis "{userdocs}\Proyectos web to date" existent ist
function createdir_db_es(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Proyectos web to date')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [FR] Projekt-Verzeichnis "{userdocs}\Projets web to date" existent ist
function createdir_db_fr(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\Projets web to date')) = True) then Result := True else Result := False;
end;

// Prfen, ob das w2d/s2d [TR] Projekt-Verzeichnis "{userdocs}\web to date projeleri" existent ist
function createdir_db_tr(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\web to date projeleri')) = True) then Result := True else Result := False;
end;

// Prfen, ob das Siquando Web/Shop [DE] Projekt-Verzeichnis "{userdocs}\SIQUANDO Web Projekte" existent ist
function createdir_sq_de(): Boolean;
begin
  if (DirExists(ExpandConstant('{userdocs}\SIQUANDO Web Projekte')) = True) then Result := True else Result := False;
end;

// Feststellen, ob zu patchendes Programm gerade geffnet ist
function AppIsInUse: Boolean;
begin
  if (CheckForMutexes('{#AppMutex}') = True) then Result := True else Result := False;
end;

// Feststellen, ob DBService.exe gerade luft
function ServiceIsInUse: Boolean;
var
  Path: String;
begin
//  if (CheckForMutexes('{#ServiceMutex}') = True) then Result := True else begin
    Path := ExpandConstant('{cf}\{cm:SharedDirName}');
//    if (Path <> '') then begin
      FileCopy(Path + ExpandConstant('\{cm:ServiceExe}'), Path + ExpandConstant('\{cm:ServiceExe}.bak'), False);
      if (DeleteFile(Path + ExpandConstant('\{cm:ServiceExe}')) = False) then begin
        DeleteFile(Path + ExpandConstant('\{cm:ServiceExe}.bak'));
        Result := True;
      end else begin
        RenameFile(Path + ExpandConstant('\{cm:ServiceExe}.bak'), Path + ExpandConstant('\{cm:ServiceExe}'));
        Result := False;
      end;
//    end else begin
//      Result := False;
//    end;
//  end;
end;

function InitializeSetup(): Boolean;
begin
  DeleteFile(RemoveBackslashUnlessRoot(GetTempDir) + '\_iu14D2N.tmp');
  DelTree(RemoveBackslashUnlessRoot(GetTempDir) + '\*', False, True, True);

  ExtractTemporaryFile('{#StylesFile}');
  LoadSkin(ExpandConstant('{tmp}\{#StylesFile}'), '{#StylesIniFile}')

// Installation nur zulassen, wenn zu patchendes Produkt auf dem System gefunden wird, ansonsten Setup abbrechen
  if ((ws2d6 = False) and (ws2d7 = False) and (ws2d8 = False)) then begin
    MsgBox(ExpandConstant('{cm:AppNotFoundMsg}'), mbCriticalError, MB_OK);
    Result := False;
    Exit;
  end else begin
// Meldung ausgeben, da zu patchende Applikation geschlossen werden mu, falls offen
    while (AppIsInUse = True) do begin
      if (MsgBox(ExpandConstant('{cm:AppIsInUseMsg}'), mbCriticalError, MB_OKCANCEL) = IDCANCEL) then begin
        Result := False;
        Exit;
      end;
    end;
    Result := True;
  end;
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
  if (CurStep = ssInstall) then begin
    if (FileExists(ExpandConstant('{pf}\ProtectDisc\License Helper\uninst.exe')) = True) then begin
      ShellExec('open',
                ExpandConstant('{pf}\ProtectDisc\License Helper\uninst.exe'),
                '/S',
                ExpandConstant('{pf}\ProtectDisc\License Helper'), SW_SHOW, ewNoWait, ErrorCode);
      Sleep(1000);
    end;
    if (FileExists(ExpandConstant('{pf}\ProtectDisc\License Helper v2\uninst.exe')) = True) then begin
      ShellExec('open',
                ExpandConstant('{pf}\ProtectDisc\License Helper v2\uninst.exe'),
                '/S',
                ExpandConstant('{pf}\ProtectDisc\License Helper v2'), SW_SHOW, ewNoWait, ErrorCode);
      Sleep(1000);
    end;
  end;
// Prfung, ob das Setup erfolgreich beendet wurde
  if (CurStep = ssPostInstall) then FinishedInstall := True;
  if (CurStep = ssDone) then begin
    if (FileExists(ExpandConstant('{pf}\Mozilla Firefox\plugins\NPPDLicenseHelper.dll')) = True) then begin
      Sleep(1000);
      DeleteFile(ExpandConstant('{pf}\Mozilla Firefox\plugins\NPPDLicenseHelper.dll'))
    end;
  end;
end;

procedure DeinitializeSetup();
begin
  ShowWindow(StrToInt(ExpandConstant('{wizardhwnd}')), 0);
  UnloadSkin();
  if (FinishedInstall = True) then begin
//    Sleep(100); // Warte-Intervall in Millisekunden
//    if (FileExists(ExpandConstant('{cf}\{cm:SharedDirName}\DBuninst.exe')) = True) then begin
//      ShellExec('open',
//                ExpandConstant('{cf}\{cm:SharedDirName}\DBuninst.exe'),
//                '/verysilent',
//                ExpandConstant('{cf}\{cm:SharedDirName}'), SW_SHOW, ewNoWait, ErrorCode);
//    end;
//#ifdef DonateUrl
//  ShellExec('open', '{#DonateUrl}', '', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
//#endif
  end;
end;

procedure DeinitializeUninstall();
begin
//
end;

function GetTempPath(Default: String): String;
begin
  Result := RemoveBackslashUnlessRoot(GetTempDir);
end;

function GetUserUID(Param: String): String;
var
  i: Integer;
  UserUID: String;
begin
  UserUID := '';
  for i := 1 to 6 do begin
    UserUID := UserUID + Chr(Random(9) + 48);
  end;
  Result := UserUID;
end;

procedure KillUpdateChecker();
begin
//  if ((FileExists(ExpandConstant('{cf}\{cm:SharedDirName}\{cm:ServiceExe}')) = True) and (ServiceIsInUse = True)) then begin
    ShellExec('open', 'taskkill.exe', ExpandConstant('/im {cm:ServiceExe} /t /f'), '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);
    ShellExec('open', 'tskill.exe', ExpandConstant('{cm:ServiceExe}'), '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);
//    DelTree(ExpandConstant('{cf}\{cm:SharedDirName}'), True, True, True);
//  end;
end;

procedure InstallVbRuntime6();
begin
//  GetVersionNumbersString(ExpandConstant('{sys}\msvbvm60.dll'), FileVersion);
//  if (FileVersion < '6.0.97.82') then begin
    ProgressPage := CreateOutputProgressPage(ExpandConstant('{cm:InstallMsg1}'), ExpandConstant('{cm:InstallMsg2}'));
//    ProgressPage.SetProgress(0, 3);
//    ProgressPage.Show;
    ProgressPage.SetText(ExpandConstant('{cm:InstallVB6Rt}'), '');
//    ProgressPage.SetProgress(1, 3);
    ExtractTemporaryFile('vbrun60sp6.exe');
    ShellExec('open', ExpandConstant('{tmp}\vbrun60sp6.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
    DeleteFile(ExpandConstant('{tmp}\vbrun60sp6.exe'));
//    ProgressPage.Hide;
//  end;
end;

procedure InstallMdac28();
begin
//  RegQueryStringValue(HKLM, 'SOFTWARE\Microsoft\Windows\CurrentVersion', 'CommonFilesDir', CommonFilesDir)
//  GetVersionNumbersString(CommonFilesDir + '\SYSTEM\ole db\Oledb32.dll', FileVersion);
//  if ((FileVersion < '2.80.1022.0') or (FileExists(CommonFilesDir + '\SYSTEM\ole db\Oledb32.dll') = False)) then begin
    ProgressPage := CreateOutputProgressPage(ExpandConstant('{cm:InstallMsg1}'), ExpandConstant('{cm:InstallMsg2}'));
//    ProgressPage.SetProgress(0, 3);
//    ProgressPage.Show;
    ProgressPage.SetText(ExpandConstant('{cm:InstallMDAC2_8}'), '');
//    ProgressPage.SetProgress(2, 3);
    ExtractTemporaryFile('mdac_typ.exe');
    ShellExec('open', ExpandConstant('{tmp}\mdac_typ.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
    DeleteFile(ExpandConstant('{tmp}\mdac_typ.exe'));
//    ProgressPage.Hide;
//  end;
end;

procedure InstallJet40();
begin
//  if (FileExists(ExpandConstant('{sys}\msjet40.dll')) = True) then begin
//    GetVersionNumbersString(ExpandConstant('{sys}\msjet40.dll'), FileVersion);
//    if (FileVersion < '4.0.8015.0') then begin
      ProgressPage := CreateOutputProgressPage(ExpandConstant('{cm:InstallMsg1}'), ExpandConstant('{cm:InstallMsg2}'));
//      ProgressPage.SetProgress(0, 3);
//      ProgressPage.Show;
      ProgressPage.SetText(ExpandConstant('{cm:InstallJET4_0}'), '');
//      ProgressPage.SetProgress(3, 3);
      ExtractTemporaryFile('Jet40SP8_9xNT.exe');
      ShellExec('open', ExpandConstant('{tmp}\Jet40SP8_9xNT.exe'), '/q:1 /r:n', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
      DeleteFile(ExpandConstant('{tmp}\Jet40SP8_9xNT.exe'));
//      ProgressPage.Hide;
//    end;
//  end;
end;
