
#define AppPublisher "HPH-Software GmbH"
#define AppManufacturer "TeamViewer GmbH"
#define AppName "TeamViewer (" + AppPublisher + ")"
#define AppExeFile "TeamViewerQS.exe"
#define AppIcoFile "TeamViewer.ico"
#define AppVersion GetFileVersion("Data\Files\" + AppExeFile)

#define ProcessName "teamviewer.exe"
#define OutputBaseFilename "hph24"

[Setup]
VersionInfoCompany={#AppPublisher}
VersionInfoCopyright={#AppManufacturer}
VersionInfoDescription={#AppName}
VersionInfoProductName={#AppName}
VersionInfoTextVersion={#AppVersion}
VersionInfoVersion={#AppVersion}

AppName={#AppName}
AppVersion={#AppVersion}

CreateAppDir=no
PrivilegesRequired=lowest

OutputDir=.
OutputBaseFilename={#OutputBaseFilename}
Compression=zip/1
InternalCompressLevel=max

Uninstallable=no

SetupIconFile=Data\Setup\{#AppIcoFile}

SignTool=hph1
SignTool=hph2
SignToolRetryCount=10

[Files]
Source: Data\Files\*; Flags: dontcopy

[Code]
var
  ErrorCode: Integer;

function InitializeSetup(): Boolean;
begin
  ShellExec('open', 'tskill.exe', '{#ProcessName} /a', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);
  ShellExec('open', 'taskkill.exe', '/f /im {#ProcessName} /t', '', SW_HIDE, ewWaitUntilTerminated, ErrorCode);
end;

procedure DeinitializeSetup();
begin
  ExtractTemporaryFile('{#AppExeFile}');
  ShellExec('open', ExpandConstant('{tmp}\{#AppExeFile}'), '', '', SW_SHOW, ewNoWait, ErrorCode);
end;
